"use strict";
const electron = require("electron");
const CHANNEL_GET_CONFIG = "llonebot_get_config";
const CHANNEL_SET_CONFIG = "llonebot_set_config";
const CHANNEL_LOG = "llonebot_log";
const CHANNEL_ERROR = "llonebot_error";
const CHANNEL_UPDATE = "llonebot_update";
const CHANNEL_CHECK_VERSION = "llonebot_check_version";
const CHANNEL_SELECT_FILE = "llonebot_select_ffmpeg";
const llonebot = {
  log: (data) => {
    electron.ipcRenderer.send(CHANNEL_LOG, data);
  },
  checkVersion: async () => {
    return electron.ipcRenderer.invoke(CHANNEL_CHECK_VERSION);
  },
  updateLLOneBot: async () => {
    return electron.ipcRenderer.invoke(CHANNEL_UPDATE);
  },
  setConfig: async (ask, config) => {
    return electron.ipcRenderer.invoke(CHANNEL_SET_CONFIG, ask, config);
  },
  getConfig: async () => {
    return electron.ipcRenderer.invoke(CHANNEL_GET_CONFIG);
  },
  getError: async () => {
    return electron.ipcRenderer.invoke(CHANNEL_ERROR);
  },
  selectFile: () => {
    return electron.ipcRenderer.invoke(CHANNEL_SELECT_FILE);
  }
};
electron.contextBridge.exposeInMainWorld("llonebot", llonebot);
